package com.ejie.p06b.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Locale;

import com.ejie.p06b.datatype.model.P06B22T00Datatype;
import com.ejie.p06b.datatype.model.P06B24T00Datatype;
import com.ejie.p06b.general.P06BConstantes;
import com.ejie.p06b.general.P06BTablas;
import com.ejie.p06b.log.P06BLog;
import com.ejie.p06b.util.P06BFecha;
import com.ejie.p06b.util.bd.P06BServidorConexionesBD;

/**
 * XXXX
 * Inserte aqu� la descripci�n del tipo.
 * Fecha de creaci�n: (05/06/07)
 */
public class P06B24T00DAO {

	static private P06B24T00DAO instance = null;

	public static P06B24T00DAO getInstance() {
	     if (instance == null) {
	          synchronized (P06B24T00DAO.class) {
	          		if (instance == null) {
	                     instance = new P06B24T00DAO();
	                }
	          }
	     }
	     return instance;
	}

	/**
    * Inserta un registro de la BD
    * @param obj.
    *            objeto a insertar
    * @return String -> El numero de expediente generado
    * @throws SQLException
    */
	public void insert(P06B24T00Datatype obj) throws SQLException{
		P06BLog.send(2,this, "Inicio P06B24T00DAO-insert");

		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        String sql = INSERT_COMPLETA;
        lstm = lconConexion.prepareStatement(sql);

    	lstm.setString(1,obj.getTipo().toUpperCase());
	    lstm.setString(2,obj.getnExpediente().toUpperCase());
	    lstm.setString(3,obj.getIdentificador().toUpperCase());
	    lstm.setString(4,obj.getNombre().toUpperCase());
	    lstm.setString(5,obj.getApe1().toUpperCase());
	    lstm.setString(6,obj.getApe2().toUpperCase());
	    lstm.setString(7,obj.getDomici().toUpperCase());
	    lstm.setString(8,obj.getCodmun().toUpperCase());
	    lstm.setString(9,obj.getLocali().toUpperCase());
	    lstm.setString(10,obj.getCodpro().toUpperCase());
	    lstm.setString(11,obj.getCodpst().toUpperCase());
	    lstm.setString(12,obj.getPais().toUpperCase());
	    lstm.setString(13,obj.getProfesi().toUpperCase());
	    lstm.setString(14,obj.getCurso().toUpperCase());
	    lstm.setString(15,obj.getDenCurso().toUpperCase());
	    lstm.setString(16,obj.getFechNom().toUpperCase());
	    lstm.setString(17,obj.getFecSus().toUpperCase());
	    lstm.setString(18,obj.getFecLeSus().toUpperCase());
	    lstm.setString(19,obj.getFecRev().toUpperCase());
	    lstm.setString(20,obj.getFecInha().toUpperCase());
	    lstm.setString(21,obj.getDurHab().toUpperCase());
	    lstm.setString(22,obj.getFecCese().toUpperCase());
	    lstm.setString(23,obj.getSanciones().toUpperCase());
	    lstm.setString(24,obj.getAcredita().toUpperCase());
	    lstm.setString(25,obj.getDAcredita().toUpperCase());
	    lstm.setString(26,obj.getAcreditaH().toUpperCase());
	    lstm.setString(27,obj.getDAcreditaH().toUpperCase());
	    lstm.setString(28,obj.getVinculaciones().toUpperCase());
	    lstm.setString(29,obj.getEnAseAutori().toUpperCase());
		if ( obj.getIdCargo()==null || obj.getIdCargo().trim().equals("") || obj.getIdCargo().trim().equals("0")){
		    lstm.setString(30,"0");
		}else{
		    lstm.setString(30,obj.getIdCargo().toUpperCase());
		}
//	    lstm.setString(31,obj.getDenCargo().toUpperCase());


    	lstm.executeUpdate();
    	//Cierro recursos
    	try {
    		if(lrst!=null) lrst.close();
    	}catch (Exception rse) {}
        try {
        	if(lstm!=null) lstm.close();
        }catch (Exception sse) {}
        try {
        	if(lconConexion!=null)lconConexion.close();
        }catch (Exception cse) {}
        P06BLog.send(2,this, "Fin P06B24T00DAO-insert");
	}

	/**
    * Obtiene la lista de organos de direcci�n asociados al expediente
    * @param expediente.
    * @param tipo 1:organo direccion 2:direccion tecnica 3:otros direccion 4:administradores
    * @return Lista de objetos administrador
	 * @throws Exception
    */
	public ArrayList selectAllByExp(String expediente, String tipo) throws Exception{
		P06BLog.send(2,this, "Inicio P06B24T00Datatype-selectAllByExp");
		ArrayList lista = new ArrayList();
		P06B24T00Datatype obj = null;
		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        String sql = SELECTALL_BY_EXP;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        try {
        	lstm = lconConexion.prepareStatement(sql);
        	lstm.setString(1,expediente.toUpperCase());
        	lstm.setString(2,tipo);
        	lrst = lstm.executeQuery();
        	//int cont = 0;//TODO Para que se usa cont??????? pq se le asigna al numExp????
	        while (lrst.next()) {
	        	obj = new P06B24T00Datatype();
	        	//obj.setnExpediente(cont+"");

	        	obj.setTipo(lrst.getString(P06BTablas.P06B_P06B24_TIPO));
	        	obj.setnExpediente(lrst.getString(P06BTablas.P06B_P06B24_NUMEXP));
			    obj.setIdentificador(lrst.getString(P06BTablas.P06B_P06B24_IDENTIFICADOR));
			    obj.setNombre(lrst.getString(P06BTablas.P06B_P06B24_NOMBRE)==null?"":lrst.getString(P06BTablas.P06B_P06B24_NOMBRE));
	        	obj.setApe1(lrst.getString(P06BTablas.P06B_P06B24_APE1)==null?"":lrst.getString(P06BTablas.P06B_P06B24_APE1));
	        	obj.setApe2(lrst.getString(P06BTablas.P06B_P06B24_APE2)==null?"":lrst.getString(P06BTablas.P06B_P06B24_APE2));
	        	obj.setDomici(lrst.getString(P06BTablas.P06B_P06B24_DOMICI)==null?"":lrst.getString(P06BTablas.P06B_P06B24_DOMICI));
	        	obj.setCodmun(lrst.getString(P06BTablas.P06B_P06B24_CODMUN)==null?"":lrst.getString(P06BTablas.P06B_P06B24_CODMUN));
	        	obj.setLocali(lrst.getString(P06BTablas.P06B_P06B24_LOCALI)==null?"":lrst.getString(P06BTablas.P06B_P06B24_LOCALI));
	        	obj.setCodpro(lrst.getString(P06BTablas.P06B_P06B24_CODPRO)==null?"":lrst.getString(P06BTablas.P06B_P06B24_CODPRO));
	        	obj.setCodpst(lrst.getString(P06BTablas.P06B_P06B24_CODPST)==null?"":lrst.getString(P06BTablas.P06B_P06B24_CODPST));
	        	obj.setPais(lrst.getString(P06BTablas.P06B_P06B24_PAIS)==null?"":lrst.getString(P06BTablas.P06B_P06B24_PAIS));
	        	obj.setProfesi(lrst.getString(P06BTablas.P06B_P06B24_PROFESI)==null?"":lrst.getString(P06BTablas.P06B_P06B24_PROFESI));
	        	obj.setCurso(lrst.getString(P06BTablas.P06B_P06B24_CURSO)==null?"":lrst.getString(P06BTablas.P06B_P06B24_CURSO));
	        	obj.setDenCurso(lrst.getString(P06BTablas.P06B_P06B24_DENCURSO)==null?"":lrst.getString(P06BTablas.P06B_P06B24_DENCURSO));
			    obj.setFechNom(lrst.getString(P06BTablas.P06B_P06B24_FECHNOM)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B24_FECHNOM),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
			    obj.setFecSus(lrst.getString(P06BTablas.P06B_P06B24_FECSUS)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B24_FECSUS),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
			    obj.setFecLeSus(lrst.getString(P06BTablas.P06B_P06B24_FECLESUS)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B24_FECLESUS),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
			    obj.setFecRev(lrst.getString(P06BTablas.P06B_P06B24_FECREV)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B24_FECREV),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
			    obj.setFecInha(lrst.getString(P06BTablas.P06B_P06B24_FECINHA)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B24_FECINHA),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
	        	obj.setDurHab(lrst.getString(P06BTablas.P06B_P06B24_DURHAB)==null?"":lrst.getString(P06BTablas.P06B_P06B24_DURHAB));
			    obj.setFecCese(lrst.getString(P06BTablas.P06B_P06B24_FECCESE)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B24_FECCESE),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
	        	obj.setSanciones(lrst.getString(P06BTablas.P06B_P06B24_SANCIONES)==null?"":lrst.getString(P06BTablas.P06B_P06B24_SANCIONES));
	        	obj.setAcredita(lrst.getString(P06BTablas.P06B_P06B24_ACREDITA)==null?"":lrst.getString(P06BTablas.P06B_P06B24_ACREDITA));
	        	obj.setDAcredita(lrst.getString(P06BTablas.P06B_P06B24_DACREDITA)==null?"":lrst.getString(P06BTablas.P06B_P06B24_DACREDITA));
	        	obj.setAcreditaH(lrst.getString(P06BTablas.P06B_P06B24_ACREDITAH)==null?"":lrst.getString(P06BTablas.P06B_P06B24_ACREDITAH));
	        	obj.setDAcreditaH(lrst.getString(P06BTablas.P06B_P06B24_DACREDITAH)==null?"":lrst.getString(P06BTablas.P06B_P06B24_DACREDITAH));
	        	obj.setVinculaciones(lrst.getString(P06BTablas.P06B_P06B24_VINCULACIONES)==null?"":lrst.getString(P06BTablas.P06B_P06B24_VINCULACIONES));
	        	obj.setEnAseAutori(lrst.getString(P06BTablas.P06B_P06B24_ENASEAUTORI)==null?"":lrst.getString(P06BTablas.P06B_P06B24_ENASEAUTORI));
			    obj.setIdCargo(lrst.getString(P06BTablas.P06B_P06B24_IDCARGO)==null?"":lrst.getString(P06BTablas.P06B_P06B24_IDCARGO));
//			    obj.setDenCargo(lrst.getString(P06BTablas.P06B_P06B24_DENCARGO)==null?"":lrst.getString(P06BTablas.P06B_P06B24_DENCARGO));

	        	//cont++;
	        	lista.add(obj);
	        }
	        P06BLog.send(2,this, "Fin P06B24T00Datatype-selectAllByExp");
	    } catch (SQLException e) {
	    	P06BLog.send(2,this, "error: " +e.getMessage());
        	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	        //Propago la excepci�n
	        throw e;
	    }catch (Exception e2) {
        	P06BLog.send(2,this, "error: " +e2.getMessage());
        	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	        //Propago la excepci�n
	        throw e2;
	    }finally {
	    	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	    }
		return lista;
	}

	/**
    * Obtiene la lista de socios asociados al expediente
    * @param expediente.
    * @param tipo 1:socio directo 2:socio indirecto 3:auxiliar externo
    * @return Lista de objetos socios
	 * @throws Exception
    */
	public ArrayList select24ByIncorporacionDEC(String expediente, String tipo, int nEjerIncorporarDEC) throws SQLException{
		P06BLog.send(2,this, "Inicio P06B24T00DAO-select24ByIncorporacionDEC");
		ArrayList lista = new ArrayList();
		P06B24T00Datatype obj24 = null;
		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        String sql = SELECTALL_INCORPORACION_BY_EXP;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        try {
        	lstm = lconConexion.prepareStatement(sql);
        	lstm.setString(1,expediente.toUpperCase());
        	lstm.setInt(2,nEjerIncorporarDEC);
        	lstm.setString(3,tipo);
        	lstm.setString(4,expediente.toUpperCase());
        	lstm.setString(5,tipo);
        	lstm.setString(6,expediente.toUpperCase());
        	lstm.setInt(7,nEjerIncorporarDEC);
        	lstm.setString(8,tipo);
        	lstm.setString(9,tipo);
        	lstm.setString(10,expediente.toUpperCase());
        	lstm.setString(11,expediente.toUpperCase());
        	lstm.setInt(12,nEjerIncorporarDEC);
        	lstm.setString(13,tipo);
        	lstm.setString(14,expediente.toUpperCase());
        	lstm.setString(15,tipo);
        	lstm.setString(16,tipo);
        	lstm.setString(17,expediente.toUpperCase());
        	lrst = lstm.executeQuery();
        	//int cont = 0; //TODO Para que se usa cont??????? pq se le asigna al numExp????
	        while (lrst.next()) {
	        	int operacion = lrst.getInt("operacion");
	        	boolean moverCampos24 = false;
	        	boolean moverCampos34 = false;
	        	boolean bHayDatosOriginales = false;
	        	if (operacion==0){
	        		moverCampos24 = true;
	        		bHayDatosOriginales = true;
	        	}else if (operacion==1){
	        		moverCampos34 = true;
	        	}else if (operacion==2){
	        		moverCampos24 = true;
	        		moverCampos34 = true;
	        		bHayDatosOriginales = true;
	        	}

	        	obj24 = new P06B24T00Datatype();
	        	obj24.setOperacion(operacion);
	        	if (moverCampos24==true){
				    obj24.setnExpediente(expediente.toUpperCase());
		        	obj24.setTipo(tipo);
				    obj24.setIdentificador(lrst.getString(P06BTablas.P06B_P06B24_IDENTIFICADOR));
				    obj24.setNombre(lrst.getString(P06BTablas.P06B_P06B24_NOMBRE)==null?"":lrst.getString(P06BTablas.P06B_P06B24_NOMBRE));
				    obj24.setApe1(lrst.getString(P06BTablas.P06B_P06B24_APE1)==null?"":lrst.getString(P06BTablas.P06B_P06B24_APE1));
				    obj24.setApe2(lrst.getString(P06BTablas.P06B_P06B24_APE2)==null?"":lrst.getString(P06BTablas.P06B_P06B24_APE2));
				    obj24.setDomici(lrst.getString(P06BTablas.P06B_P06B24_DOMICI)==null?"":lrst.getString(P06BTablas.P06B_P06B24_DOMICI));
				    obj24.setCodmun(lrst.getString(P06BTablas.P06B_P06B24_CODMUN)==null?"":lrst.getString(P06BTablas.P06B_P06B24_CODMUN));
				    obj24.setLocali(lrst.getString(P06BTablas.P06B_P06B24_LOCALI)==null?"":lrst.getString(P06BTablas.P06B_P06B24_LOCALI));
				    obj24.setCodpro(lrst.getString(P06BTablas.P06B_P06B24_CODPRO)==null?"":lrst.getString(P06BTablas.P06B_P06B24_CODPRO));
				    obj24.setCodpst(lrst.getString(P06BTablas.P06B_P06B24_CODPST)==null?"":lrst.getString(P06BTablas.P06B_P06B24_CODPST));
		        	obj24.setPais(lrst.getString(P06BTablas.P06B_P06B24_PAIS)==null?"":lrst.getString(P06BTablas.P06B_P06B24_PAIS));
		        	obj24.setProfesi(lrst.getString(P06BTablas.P06B_P06B24_PROFESI)==null?"":lrst.getString(P06BTablas.P06B_P06B24_PROFESI));
		        	obj24.setCurso(lrst.getString(P06BTablas.P06B_P06B24_CURSO)==null?"":lrst.getString(P06BTablas.P06B_P06B24_CURSO));
		        	obj24.setDenCurso(lrst.getString(P06BTablas.P06B_P06B24_DENCURSO)==null?"":lrst.getString(P06BTablas.P06B_P06B24_DENCURSO));
				    obj24.setFechNom(lrst.getString(P06BTablas.P06B_P06B24_FECHNOM)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B24_FECHNOM),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
				    obj24.setFecSus(lrst.getString(P06BTablas.P06B_P06B24_FECSUS)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B24_FECSUS),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
				    obj24.setFecLeSus(lrst.getString(P06BTablas.P06B_P06B24_FECLESUS)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B24_FECLESUS),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
				    obj24.setFecRev(lrst.getString(P06BTablas.P06B_P06B24_FECREV)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B24_FECREV),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
				    obj24.setFecInha(lrst.getString(P06BTablas.P06B_P06B24_FECINHA)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B24_FECINHA),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
		        	obj24.setDurHab(lrst.getString(P06BTablas.P06B_P06B24_DURHAB)==null?"":lrst.getString(P06BTablas.P06B_P06B24_DURHAB));
				    obj24.setFecCese(lrst.getString(P06BTablas.P06B_P06B24_FECCESE)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B24_FECCESE),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
		        	obj24.setSanciones(lrst.getString(P06BTablas.P06B_P06B24_SANCIONES)==null?"":lrst.getString(P06BTablas.P06B_P06B24_SANCIONES));
		        	obj24.setAcredita(lrst.getString(P06BTablas.P06B_P06B24_ACREDITA)==null?"":lrst.getString(P06BTablas.P06B_P06B24_ACREDITA));
		        	obj24.setDAcredita(lrst.getString(P06BTablas.P06B_P06B24_DACREDITA)==null?"":lrst.getString(P06BTablas.P06B_P06B24_DACREDITA));
		        	obj24.setAcreditaH(lrst.getString(P06BTablas.P06B_P06B24_ACREDITAH)==null?"":lrst.getString(P06BTablas.P06B_P06B24_ACREDITAH));
		        	obj24.setDAcreditaH(lrst.getString(P06BTablas.P06B_P06B24_DACREDITAH)==null?"":lrst.getString(P06BTablas.P06B_P06B24_DACREDITAH));
		        	obj24.setVinculaciones(lrst.getString(P06BTablas.P06B_P06B24_VINCULACIONES)==null?"":lrst.getString(P06BTablas.P06B_P06B24_VINCULACIONES));
		        	obj24.setEnAseAutori(lrst.getString(P06BTablas.P06B_P06B24_ENASEAUTORI)==null?"":lrst.getString(P06BTablas.P06B_P06B24_ENASEAUTORI));
				    obj24.setIdCargo(lrst.getString(P06BTablas.P06B_P06B24_IDCARGO)==null?"":lrst.getString(P06BTablas.P06B_P06B24_IDCARGO));
//				    obj24.setDenCargo(lrst.getString(P06BTablas.P06B_P06B24_DENCARGO)==null?"":lrst.getString(P06BTablas.P06B_P06B24_DENCARGO));
	        	}

	        	if (moverCampos34==true){
				    obj24.setnExpediente(expediente.toUpperCase());
				    obj24.setTipo(tipo);
				    obj24.setIdentificador(lrst.getString(P06BTablas.P06B_P06B34_IDENTIFICADOR));
				    obj24.setNombre(lrst.getString(P06BTablas.P06B_P06B34_NOMBRE)==null?"":lrst.getString(P06BTablas.P06B_P06B34_NOMBRE));
				    obj24.setApe1(lrst.getString(P06BTablas.P06B_P06B34_APE1)==null?"":lrst.getString(P06BTablas.P06B_P06B34_APE1));
				    obj24.setApe2(lrst.getString(P06BTablas.P06B_P06B34_APE2)==null?"":lrst.getString(P06BTablas.P06B_P06B34_APE2));
				    obj24.setFechNom(lrst.getString(P06BTablas.P06B_P06B34_FECHNOM)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B34_FECHNOM),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
				    obj24.setIdCargo(lrst.getString(P06BTablas.P06B_P06B34_IDCARGO)==null?"":lrst.getString(P06BTablas.P06B_P06B34_IDCARGO));

	        	}
//			    obj24.setAprobado(0);

			    if (bHayDatosOriginales==true){
			    	P06B24T00Datatype datos24Originales = new P06B24T00Datatype();
				    datos24Originales.setnExpediente(expediente.toUpperCase());
		        	datos24Originales.setTipo(tipo);
				    datos24Originales.setIdentificador(lrst.getString(P06BTablas.P06B_P06B24_IDENTIFICADOR));
				    datos24Originales.setNombre(lrst.getString(P06BTablas.P06B_P06B24_NOMBRE)==null?"":lrst.getString(P06BTablas.P06B_P06B24_NOMBRE));
				    datos24Originales.setApe1(lrst.getString(P06BTablas.P06B_P06B24_APE1)==null?"":lrst.getString(P06BTablas.P06B_P06B24_APE1));
				    datos24Originales.setApe2(lrst.getString(P06BTablas.P06B_P06B24_APE2)==null?"":lrst.getString(P06BTablas.P06B_P06B24_APE2));
				    datos24Originales.setDomici(lrst.getString(P06BTablas.P06B_P06B24_DOMICI)==null?"":lrst.getString(P06BTablas.P06B_P06B24_DOMICI));
				    datos24Originales.setCodmun(lrst.getString(P06BTablas.P06B_P06B24_CODMUN)==null?"":lrst.getString(P06BTablas.P06B_P06B24_CODMUN));
				    datos24Originales.setLocali(lrst.getString(P06BTablas.P06B_P06B24_LOCALI)==null?"":lrst.getString(P06BTablas.P06B_P06B24_LOCALI));
				    datos24Originales.setCodpro(lrst.getString(P06BTablas.P06B_P06B24_CODPRO)==null?"":lrst.getString(P06BTablas.P06B_P06B24_CODPRO));
				    datos24Originales.setCodpst(lrst.getString(P06BTablas.P06B_P06B24_CODPST)==null?"":lrst.getString(P06BTablas.P06B_P06B24_CODPST));
				    datos24Originales.setPais(lrst.getString(P06BTablas.P06B_P06B24_PAIS)==null?"":lrst.getString(P06BTablas.P06B_P06B24_PAIS));
				    datos24Originales.setProfesi(lrst.getString(P06BTablas.P06B_P06B24_PROFESI)==null?"":lrst.getString(P06BTablas.P06B_P06B24_PROFESI));
				    datos24Originales.setCurso(lrst.getString(P06BTablas.P06B_P06B24_CURSO)==null?"":lrst.getString(P06BTablas.P06B_P06B24_CURSO));
				    datos24Originales.setDenCurso(lrst.getString(P06BTablas.P06B_P06B24_DENCURSO)==null?"":lrst.getString(P06BTablas.P06B_P06B24_DENCURSO));
				    datos24Originales.setFechNom(lrst.getString(P06BTablas.P06B_P06B24_FECHNOM)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B24_FECHNOM),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
				    datos24Originales.setFecSus(lrst.getString(P06BTablas.P06B_P06B24_FECSUS)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B24_FECSUS),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
				    datos24Originales.setFecLeSus(lrst.getString(P06BTablas.P06B_P06B24_FECLESUS)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B24_FECLESUS),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
				    datos24Originales.setFecRev(lrst.getString(P06BTablas.P06B_P06B24_FECREV)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B24_FECREV),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
				    datos24Originales.setFecInha(lrst.getString(P06BTablas.P06B_P06B24_FECINHA)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B24_FECINHA),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
				    datos24Originales.setDurHab(lrst.getString(P06BTablas.P06B_P06B24_DURHAB)==null?"":lrst.getString(P06BTablas.P06B_P06B24_DURHAB));
				    datos24Originales.setFecCese(lrst.getString(P06BTablas.P06B_P06B24_FECCESE)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B24_FECCESE),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
				    datos24Originales.setSanciones(lrst.getString(P06BTablas.P06B_P06B24_SANCIONES)==null?"":lrst.getString(P06BTablas.P06B_P06B24_SANCIONES));
				    datos24Originales.setAcredita(lrst.getString(P06BTablas.P06B_P06B24_ACREDITA)==null?"":lrst.getString(P06BTablas.P06B_P06B24_ACREDITA));
				    datos24Originales.setDAcredita(lrst.getString(P06BTablas.P06B_P06B24_DACREDITA)==null?"":lrst.getString(P06BTablas.P06B_P06B24_DACREDITA));
				    datos24Originales.setAcreditaH(lrst.getString(P06BTablas.P06B_P06B24_ACREDITAH)==null?"":lrst.getString(P06BTablas.P06B_P06B24_ACREDITAH));
				    datos24Originales.setDAcreditaH(lrst.getString(P06BTablas.P06B_P06B24_DACREDITAH)==null?"":lrst.getString(P06BTablas.P06B_P06B24_DACREDITAH));
				    datos24Originales.setVinculaciones(lrst.getString(P06BTablas.P06B_P06B24_VINCULACIONES)==null?"":lrst.getString(P06BTablas.P06B_P06B24_VINCULACIONES));
				    datos24Originales.setEnAseAutori(lrst.getString(P06BTablas.P06B_P06B24_ENASEAUTORI)==null?"":lrst.getString(P06BTablas.P06B_P06B24_ENASEAUTORI));
				    datos24Originales.setIdCargo(lrst.getString(P06BTablas.P06B_P06B24_IDCARGO)==null?"":lrst.getString(P06BTablas.P06B_P06B24_IDCARGO));
//				    datos24Originales.setDenCargo(lrst.getString(P06BTablas.P06B_P06B24_DENCARGO)==null?"":lrst.getString(P06BTablas.P06B_P06B24_DENCARGO));
			    	obj24.setDatos24Originales(datos24Originales);
        		}

			    //Ojo con los Double, Cambio los puntos por comas
//				    obj34.setParticipa(obj34.getParticipa().replaceAll("\\.",","));
				//Si el idioma es euskera, formatear correctamente las fechas
//					if(idioma.equals(P06BConstantes.P06B_IDIOMA_EU)){
//						obj34.setFecAlta(P06BFecha.fechaEuFromFecha(obj34.getFecAlta()));
//					}

	        	//cont++;
	        	lista.add(obj24);
	        }
	        P06BLog.send(2,this, "Fin P06B24T00DAO-select24ByIncorporacionDEC");
	    } catch (SQLException e) {
	    	P06BLog.send(2,this, "error: " +e.getMessage());
	    }finally {
	 		if(lrst!=null)
	 			lrst.close();
        	if(lstm!=null)
        		lstm.close();
        	if(lconConexion!=null)
        		lconConexion.close();
	    }
		return lista;
	}

	/**
    * Obtiene la lista de socios asociados al expediente
    * @param expediente.
    * @param tipo 1:socio directo 2:socio indirecto 3:auxiliar externo
    * @return Lista de objetos socios
	 * @throws Exception
    */
	public ArrayList select24ByIncorporacionModTramitagune(String expediente, String tipo, int nCorrelAtencionPeticionEnRevision) throws SQLException{
		P06BLog.send(2,this, "Inicio P06B24T00DAO-select24ByIncorporacionModTramitagune");
		ArrayList lista = new ArrayList();
		P06B24T00Datatype obj24 = null;
		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        String sql = SELECTALL_INCORPORACIONMODTRAMITAGUNE_BY_EXP;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        try {
        	lstm = lconConexion.prepareStatement(sql);
        	lstm.setString(1,expediente.toUpperCase());
        	lstm.setInt(2,nCorrelAtencionPeticionEnRevision);
        	lstm.setString(3,tipo);
        	lstm.setString(4,expediente.toUpperCase());
//        	lstm.setString(5,tipo);
//        	lstm.setString(6,expediente.toUpperCase());
//        	lstm.setInt(7,nCorrelAtencionPeticionEnRevision);
//        	lstm.setString(8,tipo);
//        	lstm.setString(9,tipo);
//        	lstm.setString(10,expediente.toUpperCase());
//        	lstm.setString(11,expediente.toUpperCase());
        	lstm.setInt(5,nCorrelAtencionPeticionEnRevision);
        	lstm.setString(6,tipo);
        	lstm.setString(7,expediente.toUpperCase());
        	lstm.setString(8,tipo);
        	lstm.setInt(9,nCorrelAtencionPeticionEnRevision);
        	lstm.setString(10,tipo);
        	lstm.setString(11,expediente.toUpperCase());
        	lrst = lstm.executeQuery();
        	//int cont = 0; //TODO Para que se usa cont??????? pq se le asigna al numExp????
	        while (lrst.next()) {
	        	int operacion = lrst.getInt("operacion");
	        	boolean moverCampos24 = false;
	        	boolean moverCampos34 = false;
	        	boolean bHayDatosOriginales = false;
	        	if (operacion==0){
	        		moverCampos24 = true;
	        		bHayDatosOriginales = true;
	        	}else if (operacion==1){
	        		moverCampos34 = true;
	        	}else if (operacion==2){
	        		moverCampos24 = true;
	        		moverCampos34 = true;
	        		bHayDatosOriginales = true;
	        	}

	        	obj24 = new P06B24T00Datatype();
			    obj24.setnExpediente(expediente.toUpperCase());
	        	obj24.setOperacion(operacion);
//			    obj24.setAprobado(0);
	        	if (operacion==0){
		        	obj24.setTipo(tipo);
				    obj24.setIdentificador(lrst.getString(P06BTablas.P06B_P06B24_IDENTIFICADOR));
				    obj24.setNombre(lrst.getString(P06BTablas.P06B_P06B24_NOMBRE)==null?"":lrst.getString(P06BTablas.P06B_P06B24_NOMBRE));
				    obj24.setApe1(lrst.getString(P06BTablas.P06B_P06B24_APE1)==null?"":lrst.getString(P06BTablas.P06B_P06B24_APE1));
				    obj24.setApe2(lrst.getString(P06BTablas.P06B_P06B24_APE2)==null?"":lrst.getString(P06BTablas.P06B_P06B24_APE2));
		        	obj24.setCurso(lrst.getString(P06BTablas.P06B_P06B24_CURSO)==null?"":lrst.getString(P06BTablas.P06B_P06B24_CURSO));
		        	obj24.setDenCurso(lrst.getString(P06BTablas.P06B_P06B24_DENCURSO)==null?"":lrst.getString(P06BTablas.P06B_P06B24_DENCURSO));
				    obj24.setFechNom(lrst.getString(P06BTablas.P06B_P06B24_FECHNOM)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B24_FECHNOM),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
				    obj24.setIdCargo(lrst.getString(P06BTablas.P06B_P06B24_IDCARGO)==null?"":lrst.getString(P06BTablas.P06B_P06B24_IDCARGO));
//				    obj24.setDenCargo(lrst.getString(P06BTablas.P06B_P06B24_DENCARGO)==null?"":lrst.getString(P06BTablas.P06B_P06B24_DENCARGO));
				    obj24.setDomici(lrst.getString(P06BTablas.P06B_P06B24_DOMICI)==null?"":lrst.getString(P06BTablas.P06B_P06B24_DOMICI));
				    obj24.setCodmun(lrst.getString(P06BTablas.P06B_P06B24_CODMUN)==null?"":lrst.getString(P06BTablas.P06B_P06B24_CODMUN));
				    obj24.setLocali(lrst.getString(P06BTablas.P06B_P06B24_LOCALI)==null?"":lrst.getString(P06BTablas.P06B_P06B24_LOCALI));
				    obj24.setCodpro(lrst.getString(P06BTablas.P06B_P06B24_CODPRO)==null?"":lrst.getString(P06BTablas.P06B_P06B24_CODPRO));
				    obj24.setCodpst(lrst.getString(P06BTablas.P06B_P06B24_CODPST)==null?"":lrst.getString(P06BTablas.P06B_P06B24_CODPST));
				    obj24.setPais(lrst.getString(P06BTablas.P06B_P06B24_PAIS)==null?"":lrst.getString(P06BTablas.P06B_P06B24_PAIS));
				    obj24.setProfesi(lrst.getString(P06BTablas.P06B_P06B24_PROFESI)==null?"":lrst.getString(P06BTablas.P06B_P06B24_PROFESI));
				    obj24.setFecSus(lrst.getString(P06BTablas.P06B_P06B24_FECSUS)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B24_FECSUS),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
				    obj24.setFecLeSus(lrst.getString(P06BTablas.P06B_P06B24_FECLESUS)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B24_FECLESUS),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
				    obj24.setFecRev(lrst.getString(P06BTablas.P06B_P06B24_FECREV)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B24_FECREV),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
				    obj24.setFecInha(lrst.getString(P06BTablas.P06B_P06B24_FECINHA)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B24_FECINHA),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
				    obj24.setDurHab(lrst.getString(P06BTablas.P06B_P06B24_DURHAB)==null?"":lrst.getString(P06BTablas.P06B_P06B24_DURHAB));
				    obj24.setFecCese(lrst.getString(P06BTablas.P06B_P06B24_FECCESE)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B24_FECCESE),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
				    obj24.setSanciones(lrst.getString(P06BTablas.P06B_P06B24_SANCIONES)==null?"":lrst.getString(P06BTablas.P06B_P06B24_SANCIONES));
				    obj24.setAcredita(lrst.getString(P06BTablas.P06B_P06B24_ACREDITA)==null?"":lrst.getString(P06BTablas.P06B_P06B24_ACREDITA));
				    obj24.setDAcredita(lrst.getString(P06BTablas.P06B_P06B24_DACREDITA)==null?"":lrst.getString(P06BTablas.P06B_P06B24_DACREDITA));
				    obj24.setAcreditaH(lrst.getString(P06BTablas.P06B_P06B24_ACREDITAH)==null?"":lrst.getString(P06BTablas.P06B_P06B24_ACREDITAH));
				    obj24.setDAcreditaH(lrst.getString(P06BTablas.P06B_P06B24_DACREDITAH)==null?"":lrst.getString(P06BTablas.P06B_P06B24_DACREDITAH));
				    obj24.setVinculaciones(lrst.getString(P06BTablas.P06B_P06B24_VINCULACIONES)==null?"":lrst.getString(P06BTablas.P06B_P06B24_VINCULACIONES));
				    obj24.setEnAseAutori(lrst.getString(P06BTablas.P06B_P06B24_ENASEAUTORI)==null?"":lrst.getString(P06BTablas.P06B_P06B24_ENASEAUTORI));
	        	}

	        	if (operacion==1 || operacion==2){
				    obj24.setTipo(tipo);
				    obj24.setIdentificador(lrst.getString(P06BTablas.P06B_P06B74_OD_IDENTIFICADOR));
//				    obj24.setTipo1(lrst.getString(P06BTablas.P06B_P06B74_OD_TIPO1));
				    obj24.setNombre(lrst.getString(P06BTablas.P06B_P06B74_OD_NOMBRE)==null?"":lrst.getString(P06BTablas.P06B_P06B74_OD_NOMBRE));
				    obj24.setFechNom(lrst.getString(P06BTablas.P06B_P06B74_OD_FECHNOM)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B74_OD_FECHNOM),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
				    obj24.setIdCargo(lrst.getString(P06BTablas.P06B_P06B74_OD_IDCARGO)==null?"":lrst.getString(P06BTablas.P06B_P06B74_OD_IDCARGO));
//				    obj24.setIdRep(lrst.getString(P06BTablas.P06B_P06B74_OD_IDREP)==null?"":lrst.getString(P06BTablas.P06B_P06B74_OD_IDREP));
//				    obj24.setNomRep(lrst.getString(P06BTablas.P06B_P06B74_OD_NOMREP)==null?"":lrst.getString(P06BTablas.P06B_P06B74_OD_NOMREP));
				    obj24.setCurso(lrst.getString(P06BTablas.P06B_P06B74_OD_IDCURSO)==null?"":lrst.getString(P06BTablas.P06B_P06B74_OD_IDCURSO));
				    obj24.setDenCurso(lrst.getString(P06BTablas.P06B_P06B74_OD_DENCURSO)==null?"":lrst.getString(P06BTablas.P06B_P06B74_OD_DENCURSO));
				    if (operacion==2){
				    	//Inicializar campos no aportados por Tramitagune para que no se pierdan
					    obj24.setDomici(lrst.getString(P06BTablas.P06B_P06B24_DOMICI)==null?"":lrst.getString(P06BTablas.P06B_P06B24_DOMICI));
					    obj24.setCodmun(lrst.getString(P06BTablas.P06B_P06B24_CODMUN)==null?"":lrst.getString(P06BTablas.P06B_P06B24_CODMUN));
					    obj24.setLocali(lrst.getString(P06BTablas.P06B_P06B24_LOCALI)==null?"":lrst.getString(P06BTablas.P06B_P06B24_LOCALI));
					    obj24.setCodpro(lrst.getString(P06BTablas.P06B_P06B24_CODPRO)==null?"":lrst.getString(P06BTablas.P06B_P06B24_CODPRO));
					    obj24.setCodpst(lrst.getString(P06BTablas.P06B_P06B24_CODPST)==null?"":lrst.getString(P06BTablas.P06B_P06B24_CODPST));
					    obj24.setPais(lrst.getString(P06BTablas.P06B_P06B24_PAIS)==null?"":lrst.getString(P06BTablas.P06B_P06B24_PAIS));
					    obj24.setProfesi(lrst.getString(P06BTablas.P06B_P06B24_PROFESI)==null?"":lrst.getString(P06BTablas.P06B_P06B24_PROFESI));
					    obj24.setFecSus(lrst.getString(P06BTablas.P06B_P06B24_FECSUS)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B24_FECSUS),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
					    obj24.setFecLeSus(lrst.getString(P06BTablas.P06B_P06B24_FECLESUS)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B24_FECLESUS),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
					    obj24.setFecRev(lrst.getString(P06BTablas.P06B_P06B24_FECREV)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B24_FECREV),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
					    obj24.setFecInha(lrst.getString(P06BTablas.P06B_P06B24_FECINHA)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B24_FECINHA),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
					    obj24.setDurHab(lrst.getString(P06BTablas.P06B_P06B24_DURHAB)==null?"":lrst.getString(P06BTablas.P06B_P06B24_DURHAB));
					    obj24.setFecCese(lrst.getString(P06BTablas.P06B_P06B24_FECCESE)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B24_FECCESE),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
					    obj24.setSanciones(lrst.getString(P06BTablas.P06B_P06B24_SANCIONES)==null?"":lrst.getString(P06BTablas.P06B_P06B24_SANCIONES));
					    obj24.setAcredita(lrst.getString(P06BTablas.P06B_P06B24_ACREDITA)==null?"":lrst.getString(P06BTablas.P06B_P06B24_ACREDITA));
					    obj24.setDAcredita(lrst.getString(P06BTablas.P06B_P06B24_DACREDITA)==null?"":lrst.getString(P06BTablas.P06B_P06B24_DACREDITA));
					    obj24.setAcreditaH(lrst.getString(P06BTablas.P06B_P06B24_ACREDITAH)==null?"":lrst.getString(P06BTablas.P06B_P06B24_ACREDITAH));
					    obj24.setDAcreditaH(lrst.getString(P06BTablas.P06B_P06B24_DACREDITAH)==null?"":lrst.getString(P06BTablas.P06B_P06B24_DACREDITAH));
					    obj24.setVinculaciones(lrst.getString(P06BTablas.P06B_P06B24_VINCULACIONES)==null?"":lrst.getString(P06BTablas.P06B_P06B24_VINCULACIONES));
					    obj24.setEnAseAutori(lrst.getString(P06BTablas.P06B_P06B24_ENASEAUTORI)==null?"":lrst.getString(P06BTablas.P06B_P06B24_ENASEAUTORI));
				    }
	        	}

			    if (operacion==0 || operacion==2){
			    	P06B24T00Datatype datos24Originales = new P06B24T00Datatype();
			    	datos24Originales.setnExpediente(expediente.toUpperCase());
		        	datos24Originales.setTipo(tipo);
				    datos24Originales.setIdentificador(lrst.getString(P06BTablas.P06B_P06B24_IDENTIFICADOR));
				    datos24Originales.setNombre(lrst.getString(P06BTablas.P06B_P06B24_NOMBRE)==null?"":lrst.getString(P06BTablas.P06B_P06B24_NOMBRE));
				    datos24Originales.setApe1(lrst.getString(P06BTablas.P06B_P06B24_APE1)==null?"":lrst.getString(P06BTablas.P06B_P06B24_APE1));
				    datos24Originales.setApe2(lrst.getString(P06BTablas.P06B_P06B24_APE2)==null?"":lrst.getString(P06BTablas.P06B_P06B24_APE2));
				    datos24Originales.setDomici(lrst.getString(P06BTablas.P06B_P06B24_DOMICI)==null?"":lrst.getString(P06BTablas.P06B_P06B24_DOMICI));
				    datos24Originales.setCodmun(lrst.getString(P06BTablas.P06B_P06B24_CODMUN)==null?"":lrst.getString(P06BTablas.P06B_P06B24_CODMUN));
				    datos24Originales.setLocali(lrst.getString(P06BTablas.P06B_P06B24_LOCALI)==null?"":lrst.getString(P06BTablas.P06B_P06B24_LOCALI));
				    datos24Originales.setCodpro(lrst.getString(P06BTablas.P06B_P06B24_CODPRO)==null?"":lrst.getString(P06BTablas.P06B_P06B24_CODPRO));
				    datos24Originales.setCodpst(lrst.getString(P06BTablas.P06B_P06B24_CODPST)==null?"":lrst.getString(P06BTablas.P06B_P06B24_CODPST));
				    datos24Originales.setPais(lrst.getString(P06BTablas.P06B_P06B24_PAIS)==null?"":lrst.getString(P06BTablas.P06B_P06B24_PAIS));
				    datos24Originales.setProfesi(lrst.getString(P06BTablas.P06B_P06B24_PROFESI)==null?"":lrst.getString(P06BTablas.P06B_P06B24_PROFESI));
				    datos24Originales.setCurso(lrst.getString(P06BTablas.P06B_P06B24_CURSO)==null?"":lrst.getString(P06BTablas.P06B_P06B24_CURSO));
				    datos24Originales.setDenCurso(lrst.getString(P06BTablas.P06B_P06B24_DENCURSO)==null?"":lrst.getString(P06BTablas.P06B_P06B24_DENCURSO));
				    datos24Originales.setFechNom(lrst.getString(P06BTablas.P06B_P06B24_FECHNOM)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B24_FECHNOM),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
				    datos24Originales.setFecSus(lrst.getString(P06BTablas.P06B_P06B24_FECSUS)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B24_FECSUS),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
				    datos24Originales.setFecLeSus(lrst.getString(P06BTablas.P06B_P06B24_FECLESUS)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B24_FECLESUS),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
				    datos24Originales.setFecRev(lrst.getString(P06BTablas.P06B_P06B24_FECREV)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B24_FECREV),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
				    datos24Originales.setFecInha(lrst.getString(P06BTablas.P06B_P06B24_FECINHA)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B24_FECINHA),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
				    datos24Originales.setDurHab(lrst.getString(P06BTablas.P06B_P06B24_DURHAB)==null?"":lrst.getString(P06BTablas.P06B_P06B24_DURHAB));
				    datos24Originales.setFecCese(lrst.getString(P06BTablas.P06B_P06B24_FECCESE)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B24_FECCESE),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
				    datos24Originales.setSanciones(lrst.getString(P06BTablas.P06B_P06B24_SANCIONES)==null?"":lrst.getString(P06BTablas.P06B_P06B24_SANCIONES));
				    datos24Originales.setAcredita(lrst.getString(P06BTablas.P06B_P06B24_ACREDITA)==null?"":lrst.getString(P06BTablas.P06B_P06B24_ACREDITA));
				    datos24Originales.setDAcredita(lrst.getString(P06BTablas.P06B_P06B24_DACREDITA)==null?"":lrst.getString(P06BTablas.P06B_P06B24_DACREDITA));
				    datos24Originales.setAcreditaH(lrst.getString(P06BTablas.P06B_P06B24_ACREDITAH)==null?"":lrst.getString(P06BTablas.P06B_P06B24_ACREDITAH));
				    datos24Originales.setDAcreditaH(lrst.getString(P06BTablas.P06B_P06B24_DACREDITAH)==null?"":lrst.getString(P06BTablas.P06B_P06B24_DACREDITAH));
				    datos24Originales.setVinculaciones(lrst.getString(P06BTablas.P06B_P06B24_VINCULACIONES)==null?"":lrst.getString(P06BTablas.P06B_P06B24_VINCULACIONES));
				    datos24Originales.setEnAseAutori(lrst.getString(P06BTablas.P06B_P06B24_ENASEAUTORI)==null?"":lrst.getString(P06BTablas.P06B_P06B24_ENASEAUTORI));
				    datos24Originales.setIdCargo(lrst.getString(P06BTablas.P06B_P06B24_IDCARGO)==null?"":lrst.getString(P06BTablas.P06B_P06B24_IDCARGO));
//				    datos24Originales.setDenCargo(lrst.getString(P06BTablas.P06B_P06B24_DENCARGO)==null?"":lrst.getString(P06BTablas.P06B_P06B24_DENCARGO));
			    	obj24.setDatos24Originales(datos24Originales);
        		}

			    //Ojo con los Double, Cambio los puntos por comas
//					    obj34.setParticipa(obj34.getParticipa().replaceAll("\\.",","));
				//Si el idioma es euskera, formatear correctamente las fechas
//						if(idioma.equals(P06BConstantes.P06B_IDIOMA_EU)){
//							obj34.setFecAlta(P06BFecha.fechaEuFromFecha(obj34.getFecAlta()));
//						}

	        	//cont++;
	        	lista.add(obj24);
	        }
	        P06BLog.send(2,this, "Fin P06B24T00DAO-select24ByIncorporacionModTramitagune");
	    }finally {
	 		if(lrst!=null)
	 			lrst.close();
        	if(lstm!=null)
        		lstm.close();
        	if(lconConexion!=null)
        		lconConexion.close();
	    }
		return lista;
	}


	/**
    * Elimina todos los organos de direcci�n asociados a un expediente concreto
    * @param exp.
    *            el expediente cuyos organos de direcci�n eliminamos
    * @param tipo 1:organo direccion 2:direccion tecnica 3:otros direccion 4:administradores
    * @throws SQLException
    */
	public void deleteAllByExp(String exp, String tipo) throws SQLException{
		P06BLog.send(2,this, "Inicio P06B24T00DAO-deleteAllByExp");

		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        String sql = DELETEALL_BYEXP;
        lstm = lconConexion.prepareStatement(sql);
    	lstm.setString(1,exp.toUpperCase());
    	lstm.setString(2,tipo);
    	lstm.executeUpdate();
    	//Cierro recursos
    	try {
    		if(lrst!=null) lrst.close();
    	}catch (Exception rse) {}
        try {
        	if(lstm!=null) lstm.close();
        }catch (Exception sse) {}
        try {
        	if(lconConexion!=null)lconConexion.close();
        }catch (Exception cse) {}
        P06BLog.send(2,this, "Fin P06B24T00DAO-deleteAllByExp");
	}


	/**
    * Elimina todos los organos de direcci�n asociados a un expediente concreto
    * @param exp.
    *            el expediente cuyos organos de direcci�n eliminamos
    * @param tipo 1:organo direccion 2:direccion tecnica 3:otros direccion 4:administradores
    * @throws SQLException
    */
	public void deleteByExpId(String exp, String tipo, String id) throws SQLException{
		P06BLog.send(2,this, "Inicio P06B24T00DAO-deleteByExpId");

		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        String sql = DELETEBYEXPID;
        lstm = lconConexion.prepareStatement(sql);
    	lstm.setString(1,exp.toUpperCase());
    	lstm.setString(2,tipo);
    	lstm.setString(3,id);
    	lstm.executeUpdate();
    	//Cierro recursos
    	try {
    		if(lrst!=null) lrst.close();
    	}catch (Exception rse) {}
        try {
        	if(lstm!=null) lstm.close();
        }catch (Exception sse) {}
        try {
        	if(lconConexion!=null)lconConexion.close();
        }catch (Exception cse) {}
        P06BLog.send(2,this, "Fin P06B24T00DAO-deleteByExpId");
	}
	/**
    * Elimina todos los organos de direcci�n asociados a un expediente concreto
    * @param exp.
    *            el expediente cuyos organos de direcci�n eliminamos
    * @param tipo 1:organo direccion 2:direccion tecnica 3:otros direccion 4:administradores
    * @throws SQLException
    */
	public void deleteByExpIdCargo(String exp, String tipo, String id, String idCargo) throws SQLException{
		P06BLog.send(2,this, "Inicio P06B24T00DAO-deleteByExpIdCargo");

		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        String sql = DELETEBYEXPIDCARGO;
        lstm = lconConexion.prepareStatement(sql);
    	lstm.setString(1,exp.toUpperCase());
    	lstm.setString(2,tipo);
    	lstm.setString(3,id);
    	lstm.setString(4,idCargo);
    	lstm.executeUpdate();
    	//Cierro recursos
    	try {
    		if(lrst!=null) lrst.close();
    	}catch (Exception rse) {}
        try {
        	if(lstm!=null) lstm.close();
        }catch (Exception sse) {}
        try {
        	if(lconConexion!=null)lconConexion.close();
        }catch (Exception cse) {}
        P06BLog.send(2,this, "Fin P06B24T00DAO-deleteByExpIdCargo");
	}


	/**
    * Obtiene el objeto asociado a los parametros de entrada
    * @param expediente.
    * @param tipo 1:organo direccion 2:direccion tecnica 3:otros direccion 4:administradores
    * @param identificador: cif o nif
    * @param idCargo: cargo del admin o direc
    * @param idioma
    * @return objeto que cumple los parametros, o null si no lo encuentra
	 * @throws Exception
    */
	public P06B24T00Datatype selectByPK(String expediente, String tipo, String identificador, String idCargo, String idioma) throws Exception{
		P06BLog.send(2,this, "Inicio P06B24T00Datatype-selectByPK");
		P06B24T00Datatype obj = null;
		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        String sql = SELECTALL_BY_PK;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();

        try {
        	lstm = lconConexion.prepareStatement(sql);
        	lstm.setString(1,expediente.toUpperCase());
        	lstm.setString(2,tipo);
        	lstm.setString(3,identificador.toUpperCase());
        	lstm.setString(4,idCargo.toUpperCase());
        	lrst = lstm.executeQuery();
	        if (lrst.next()) {
	        	obj = new P06B24T00Datatype();

	        	obj.setTipo(lrst.getString(P06BTablas.P06B_P06B24_TIPO));
	        	obj.setnExpediente(lrst.getString(P06BTablas.P06B_P06B24_NUMEXP));
			    obj.setIdentificador(lrst.getString(P06BTablas.P06B_P06B24_IDENTIFICADOR));
			    obj.setNombre(lrst.getString(P06BTablas.P06B_P06B24_NOMBRE)==null?"":lrst.getString(P06BTablas.P06B_P06B24_NOMBRE));
	        	obj.setApe1(lrst.getString(P06BTablas.P06B_P06B24_APE1)==null?"":lrst.getString(P06BTablas.P06B_P06B24_APE1));
	        	obj.setApe2(lrst.getString(P06BTablas.P06B_P06B24_APE2)==null?"":lrst.getString(P06BTablas.P06B_P06B24_APE2));
	        	obj.setDomici(lrst.getString(P06BTablas.P06B_P06B24_DOMICI)==null?"":lrst.getString(P06BTablas.P06B_P06B24_DOMICI));
	        	obj.setCodmun(lrst.getString(P06BTablas.P06B_P06B24_CODMUN)==null?"":lrst.getString(P06BTablas.P06B_P06B24_CODMUN));
	        	obj.setLocali(lrst.getString(P06BTablas.P06B_P06B24_LOCALI)==null?"":lrst.getString(P06BTablas.P06B_P06B24_LOCALI));
	        	obj.setCodpro(lrst.getString(P06BTablas.P06B_P06B24_CODPRO)==null?"":lrst.getString(P06BTablas.P06B_P06B24_CODPRO));
	        	obj.setCodpst(lrst.getString(P06BTablas.P06B_P06B24_CODPST)==null?"":lrst.getString(P06BTablas.P06B_P06B24_CODPST));
	        	obj.setPais(lrst.getString(P06BTablas.P06B_P06B24_PAIS)==null?"":lrst.getString(P06BTablas.P06B_P06B24_PAIS));
	        	obj.setProfesi(lrst.getString(P06BTablas.P06B_P06B24_PROFESI)==null?"":lrst.getString(P06BTablas.P06B_P06B24_PROFESI));
	        	obj.setCurso(lrst.getString(P06BTablas.P06B_P06B24_CURSO)==null?"":lrst.getString(P06BTablas.P06B_P06B24_CURSO));
	        	obj.setDenCurso(lrst.getString(P06BTablas.P06B_P06B24_DENCURSO)==null?"":lrst.getString(P06BTablas.P06B_P06B24_DENCURSO));
			    obj.setFechNom(lrst.getString(P06BTablas.P06B_P06B24_FECHNOM)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B24_FECHNOM),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
			    obj.setFecSus(lrst.getString(P06BTablas.P06B_P06B24_FECSUS)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B24_FECSUS),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
			    obj.setFecLeSus(lrst.getString(P06BTablas.P06B_P06B24_FECLESUS)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B24_FECLESUS),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
			    obj.setFecRev(lrst.getString(P06BTablas.P06B_P06B24_FECREV)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B24_FECREV),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
			    obj.setFecInha(lrst.getString(P06BTablas.P06B_P06B24_FECINHA)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B24_FECINHA),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
	        	obj.setDurHab(lrst.getString(P06BTablas.P06B_P06B24_DURHAB)==null?"":lrst.getString(P06BTablas.P06B_P06B24_DURHAB));
			    obj.setFecCese(lrst.getString(P06BTablas.P06B_P06B24_FECCESE)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B24_FECCESE),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
	        	obj.setSanciones(lrst.getString(P06BTablas.P06B_P06B24_SANCIONES)==null?"":lrst.getString(P06BTablas.P06B_P06B24_SANCIONES));
	        	obj.setAcredita(lrst.getString(P06BTablas.P06B_P06B24_ACREDITA)==null?"":lrst.getString(P06BTablas.P06B_P06B24_ACREDITA));
	        	obj.setDAcredita(lrst.getString(P06BTablas.P06B_P06B24_DACREDITA)==null?"":lrst.getString(P06BTablas.P06B_P06B24_DACREDITA));
	        	obj.setAcreditaH(lrst.getString(P06BTablas.P06B_P06B24_ACREDITAH)==null?"":lrst.getString(P06BTablas.P06B_P06B24_ACREDITAH));
	        	obj.setDAcreditaH(lrst.getString(P06BTablas.P06B_P06B24_DACREDITAH)==null?"":lrst.getString(P06BTablas.P06B_P06B24_DACREDITAH));
	        	obj.setVinculaciones(lrst.getString(P06BTablas.P06B_P06B24_VINCULACIONES)==null?"":lrst.getString(P06BTablas.P06B_P06B24_VINCULACIONES));
	        	obj.setEnAseAutori(lrst.getString(P06BTablas.P06B_P06B24_ENASEAUTORI)==null?"":lrst.getString(P06BTablas.P06B_P06B24_ENASEAUTORI));
			    obj.setIdCargo(lrst.getString(P06BTablas.P06B_P06B24_IDCARGO)==null?"":lrst.getString(P06BTablas.P06B_P06B24_IDCARGO));
//			    obj.setDenCargo(lrst.getString(P06BTablas.P06B_P06B24_DENCARGO)==null?"":lrst.getString(P06BTablas.P06B_P06B24_DENCARGO));

			    //Si el idioma es euskera, formatear correctamente las fechas
			    if(idioma.equals(P06BConstantes.P06B_IDIOMA_EU)){
			    	obj.setFechNom(P06BFecha.fechaEuFromFecha(obj.getFechNom()));
			    	obj.setFecSus(P06BFecha.fechaEuFromFecha(obj.getFecSus()));
			    	obj.setFecLeSus(P06BFecha.fechaEuFromFecha(obj.getFecLeSus()));
			    	obj.setFecRev(P06BFecha.fechaEuFromFecha(obj.getFecRev()));
			    	obj.setFecInha(P06BFecha.fechaEuFromFecha(obj.getFecInha()));
			    	obj.setFecCese(P06BFecha.fechaEuFromFecha(obj.getFecCese()));
				}

	        }
	        P06BLog.send(2,this, "Fin P06B24T00Datatype-selectByPK");
	    } catch (SQLException e) {
	    	P06BLog.send(2,this, "error: " +e.getMessage());
        	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	        //Propago la excepci�n
	        throw e;
	    }catch (Exception e2) {
        	P06BLog.send(2,this, "error: " +e2.getMessage());
        	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	        //Propago la excepci�n
	        throw e2;
	    }finally {
	    	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	    }
		return obj;
	}


	/**
    * Obtiene el objeto asociado a los parametros de entrada
    * @return objeto que cumple los parametros, o null si no lo encuentra
	 * @throws SQLException
	* @throws Exception
    */
	public ArrayList<P06B24T00Datatype> selectInformeComunicarDGSFP2() throws SQLException{
		P06BLog.send(2,this, "Inicio P06B24T00Datatype-selectInformeComunicarDGSFP2");
		ArrayList<P06B24T00Datatype> informeComunicarDGSFP2PDF = new ArrayList<P06B24T00Datatype>();
		P06B24T00Datatype obj = null;
		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        String sql = SELECT_LISTADO2;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        try {
        	lstm = lconConexion.prepareStatement(sql);
        	lrst = lstm.executeQuery();
            int indLinea = 0;
	        while(lrst.next()) {
	        	obj = new P06B24T00Datatype();
	        	obj.setTipo(lrst.getString(1));
	        	obj.setnExpediente(lrst.getString(2));
			    obj.setIdentificador(lrst.getString(3));
			    obj.setNombre(lrst.getString(4));
	        	obj.setApe1(lrst.getString(5));
	        	obj.setApe2(lrst.getString(6));
			    obj.setFechNom(lrst.getString(7));
			    obj.setFecCese(lrst.getString(8));
			    obj.setIdCargo(lrst.getString(9));
	        	informeComunicarDGSFP2PDF.add(indLinea, obj);
        		indLinea++;
	        }
	        P06BLog.send(2,this, "Fin P06B64T00Datatype-selectInformeComunicarDGSFP2");
	    } catch (SQLException e) {
	    	P06BLog.send(2,this, "error: " +e.getMessage());
	        throw e;
	    }finally {
    		if(lrst!=null)
    			lrst.close();
        	if(lstm!=null)
        		lstm.close();
        	if(lconConexion!=null)
        		lconConexion.close();
	    }
		return informeComunicarDGSFP2PDF;
	}


	/**
    * Obtiene el n�mero de objetos del expediente y tipo indicados
    * @param expediente.
    * @param tipo 1:organo direccion 2:direccion tecnica 3:otros direccion 4:administradores
    * @return int con el n�mero de registros encontrados
	* @throws Exception
    */
	public int selectNumObj(String expediente, String tipo) throws Exception{
		P06BLog.send(2,this, "Inicio P06B24T00Datatype-selectNumObj");
		int numRegsEncontrados = 0;
		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        String sql = SELECT_NUMREGS;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();

        try {
        	lstm = lconConexion.prepareStatement(sql);
        	lstm.setString(1,expediente.toUpperCase());
        	lstm.setString(2,tipo);
        	lrst = lstm.executeQuery();
	        if (lrst.next()) {
	        	numRegsEncontrados = lrst.getInt(1);
	        }
	        P06BLog.send(2,this, "Fin P06B24T00Datatype-selectNumObj");
	    } catch (SQLException e) {
	    	P06BLog.send(2,this, "error: " +e.getMessage());
        	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	        //Propago la excepci�n
	        throw e;
	    }catch (Exception e2) {
        	P06BLog.send(2,this, "error: " +e2.getMessage());
        	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	        //Propago la excepci�n
	        throw e2;
	    }finally {
	    	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	    }
		return numRegsEncontrados;
	}



	private static String INSERT_COMPLETA =
		"INSERT INTO "+ P06BTablas.P06B_P06B24T00_TABLA +
		"("+
		P06BTablas.P06B_P06B24_TIPO + "," +
		P06BTablas.P06B_P06B24_NUMEXP + "," +
		P06BTablas.P06B_P06B24_IDENTIFICADOR + "," +
		P06BTablas.P06B_P06B24_NOMBRE + "," +
		P06BTablas.P06B_P06B24_APE1 + "," +
		P06BTablas.P06B_P06B24_APE2 + "," +
		P06BTablas.P06B_P06B24_DOMICI + "," +
		P06BTablas.P06B_P06B24_CODMUN + "," +
		P06BTablas.P06B_P06B24_LOCALI + "," +
		P06BTablas.P06B_P06B24_CODPRO + "," +
		P06BTablas.P06B_P06B24_CODPST + "," +
		P06BTablas.P06B_P06B24_PAIS + "," +
		P06BTablas.P06B_P06B24_PROFESI + "," +
		P06BTablas.P06B_P06B24_CURSO + "," +
		P06BTablas.P06B_P06B24_DENCURSO + "," +
		P06BTablas.P06B_P06B24_FECHNOM + "," +
		P06BTablas.P06B_P06B24_FECSUS + "," +
		P06BTablas.P06B_P06B24_FECLESUS + "," +
		P06BTablas.P06B_P06B24_FECREV + "," +
		P06BTablas.P06B_P06B24_FECINHA + "," +
		P06BTablas.P06B_P06B24_DURHAB + "," +
		P06BTablas.P06B_P06B24_FECCESE + "," +
		P06BTablas.P06B_P06B24_SANCIONES + "," +
		P06BTablas.P06B_P06B24_ACREDITA + "," +
		P06BTablas.P06B_P06B24_DACREDITA + "," +
		P06BTablas.P06B_P06B24_ACREDITAH + "," +
		P06BTablas.P06B_P06B24_DACREDITAH + "," +
		P06BTablas.P06B_P06B24_VINCULACIONES + "," +
		P06BTablas.P06B_P06B24_ENASEAUTORI + "," +
		P06BTablas.P06B_P06B24_IDCARGO +
//		"," + P06BTablas.P06B_P06B24_DENCARGO +
		")"+
		" VALUES(TO_NUMBER(?),?,?,?,?,?,?,TO_NUMBER(?),TO_NUMBER(?),TO_NUMBER(?),?,TO_NUMBER(?),?,?,?," +
		"TO_DATE(?,'dd/MM/yyyy'),TO_DATE(?,'dd/MM/yyyy'),TO_DATE(?,'dd/MM/yyyy'),TO_DATE(?,'dd/MM/yyyy'),TO_DATE(?,'dd/MM/yyyy')," +
		"TO_NUMBER(?),TO_DATE(?,'dd/MM/yyyy'),?,?,?,?,?,?,?,?" +
//		",?" +
		")";

	private static String SELECTALL_BY_EXP =
		"SELECT "
		+ P06BTablas.P06B_P06B24_TIPO + ", "
		+ P06BTablas.P06B_P06B24_NUMEXP + ", "
		+ P06BTablas.P06B_P06B24_IDENTIFICADOR + ", "
		+ P06BTablas.P06B_P06B24_NOMBRE + ", "
		+ P06BTablas.P06B_P06B24_APE1 + ", "
		+ P06BTablas.P06B_P06B24_APE2 + ", "
		+ P06BTablas.P06B_P06B24_DOMICI + ", "
		+ P06BTablas.P06B_P06B24_CODMUN + ", "
		+ P06BTablas.P06B_P06B24_LOCALI + ", "
		+ P06BTablas.P06B_P06B24_CODPRO + ", "
		+ P06BTablas.P06B_P06B24_CODPST + ", "
		+ P06BTablas.P06B_P06B24_PAIS + ", "
		+ P06BTablas.P06B_P06B24_PROFESI + ", "
		+ P06BTablas.P06B_P06B24_CURSO + ", "
		+ P06BTablas.P06B_P06B24_DENCURSO + ", "
		+ P06BTablas.P06B_P06B24_FECHNOM + ", "
		+ P06BTablas.P06B_P06B24_FECSUS + ", "
		+ P06BTablas.P06B_P06B24_FECLESUS + ", "
		+ P06BTablas.P06B_P06B24_FECREV + ", "
		+ P06BTablas.P06B_P06B24_FECINHA + ", "
		+ P06BTablas.P06B_P06B24_DURHAB + ", "
		+ P06BTablas.P06B_P06B24_FECCESE + ", "
		+ P06BTablas.P06B_P06B24_SANCIONES + ", "
		+ P06BTablas.P06B_P06B24_ACREDITA + ", "
		+ P06BTablas.P06B_P06B24_DACREDITA + ", "
		+ P06BTablas.P06B_P06B24_ACREDITAH + ", "
		+ P06BTablas.P06B_P06B24_DACREDITAH + ", "
		+ P06BTablas.P06B_P06B24_VINCULACIONES + ", "
		+ P06BTablas.P06B_P06B24_ENASEAUTORI + ", "
		+ P06BTablas.P06B_P06B24_IDCARGO +
//		", " + P06BTablas.P06B_P06B24_DENCARGO +
		" FROM " + P06BTablas.P06B_P06B24T00_TABLA
		+ " WHERE " + P06BTablas.P06B_P06B24_NUMEXP + "= ? "
			+ " AND " + P06BTablas.P06B_P06B24_TIPO + "= TO_NUMBER(?)"
		+" ORDER BY " + P06BTablas.P06B_P06B24_IDENTIFICADOR ;

	private static String DELETEALL_BYEXP =
		"DELETE FROM "+ P06BTablas.P06B_P06B24T00_TABLA +
		" WHERE " + P06BTablas.P06B_P06B24_NUMEXP + " = ?"
			+ " AND " + P06BTablas.P06B_P06B24_TIPO + "= TO_NUMBER(?)";

	private static String DELETEBYEXPID =
		"DELETE FROM "+ P06BTablas.P06B_P06B24T00_TABLA +
		" WHERE " + P06BTablas.P06B_P06B24_NUMEXP + " = ?"
			+ " AND " + P06BTablas.P06B_P06B24_TIPO + "= TO_NUMBER(?)"
			+ " AND " + P06BTablas.P06B_P06B24_IDENTIFICADOR + "= ?";


	private static String DELETEBYEXPIDCARGO =
		"DELETE FROM "+ P06BTablas.P06B_P06B24T00_TABLA +
		" WHERE " + P06BTablas.P06B_P06B24_NUMEXP + " = ?"
			+ " AND " + P06BTablas.P06B_P06B24_TIPO + "= TO_NUMBER(?)"
			+ " AND " + P06BTablas.P06B_P06B24_IDENTIFICADOR + "= ?"
			+ " AND " + P06BTablas.P06B_P06B24_IDCARGO + "= ?";


	private static String SELECTALL_BY_PK =
		"SELECT "
		+ P06BTablas.P06B_P06B24_TIPO + ", "
		+ P06BTablas.P06B_P06B24_NUMEXP + ", "
		+ P06BTablas.P06B_P06B24_IDENTIFICADOR + ", "
		+ P06BTablas.P06B_P06B24_NOMBRE + ", "
		+ P06BTablas.P06B_P06B24_APE1 + ", "
		+ P06BTablas.P06B_P06B24_APE2 + ", "
		+ P06BTablas.P06B_P06B24_DOMICI + ", "
		+ P06BTablas.P06B_P06B24_CODMUN + ", "
		+ P06BTablas.P06B_P06B24_LOCALI + ", "
		+ P06BTablas.P06B_P06B24_CODPRO + ", "
		+ P06BTablas.P06B_P06B24_CODPST + ", "
		+ P06BTablas.P06B_P06B24_PAIS + ", "
		+ P06BTablas.P06B_P06B24_PROFESI + ", "
		+ P06BTablas.P06B_P06B24_CURSO + ", "
		+ P06BTablas.P06B_P06B24_DENCURSO + ", "
		+ P06BTablas.P06B_P06B24_FECHNOM + ", "
		+ P06BTablas.P06B_P06B24_FECSUS + ", "
		+ P06BTablas.P06B_P06B24_FECLESUS + ", "
		+ P06BTablas.P06B_P06B24_FECREV + ", "
		+ P06BTablas.P06B_P06B24_FECINHA + ", "
		+ P06BTablas.P06B_P06B24_DURHAB + ", "
		+ P06BTablas.P06B_P06B24_FECCESE + ", "
		+ P06BTablas.P06B_P06B24_SANCIONES + ", "
		+ P06BTablas.P06B_P06B24_ACREDITA + ", "
		+ P06BTablas.P06B_P06B24_DACREDITA + ", "
		+ P06BTablas.P06B_P06B24_ACREDITAH + ", "
		+ P06BTablas.P06B_P06B24_DACREDITAH + ", "
		+ P06BTablas.P06B_P06B24_VINCULACIONES + ", "
		+ P06BTablas.P06B_P06B24_ENASEAUTORI + ", "
		+ P06BTablas.P06B_P06B24_IDCARGO +
//		", " + P06BTablas.P06B_P06B24_DENCARGO +
		" FROM " + P06BTablas.P06B_P06B24T00_TABLA
		+ " WHERE " + P06BTablas.P06B_P06B24_NUMEXP + "= ? "
			+ " AND " + P06BTablas.P06B_P06B24_TIPO + "= TO_NUMBER(?)"
			+ " AND " + P06BTablas.P06B_P06B24_IDENTIFICADOR + "= ?"
			+ " AND " + P06BTablas.P06B_P06B24_IDCARGO + "= ?";

	private static String SELECT_LISTADO2 =
		"SELECT "
		+ P06BTablas.P06B_P06B24_TIPO + ", "
		+ P06BTablas.P06B_P06B24_NUMEXP + ", "
		+ P06BTablas.P06B_P06B24_IDENTIFICADOR + ", "
		+ P06BTablas.P06B_P06B24_NOMBRE + ", "
		+ P06BTablas.P06B_P06B24_APE1 + ", "
		+ P06BTablas.P06B_P06B24_APE2 + ", "
		+ "TO_CHAR(" + P06BTablas.P06B_P06B24_FECHNOM + ", 'DD/MM/YYYY'), "
		+ "TO_CHAR(" + P06BTablas.P06B_P06B24_FECCESE + ", 'DD/MM/YYYY'), "
		+ P06BTablas.P06B_P06B24_IDCARGO +
		" FROM " + P06BTablas.P06B_P06B24T00_TABLA + ", " + P06BTablas.P06B_P06B20T00_TABLA
		+ " WHERE " + P06BTablas.P06B_P06B24_NUMEXP + "=" + P06BTablas.P06B_P06B20_NUMEXP
		+ " AND "+ P06BTablas.P06B_P06B20_ESTADO + " in ('A','S','R','V') "
		+ " ORDER BY " + P06BTablas.P06B_P06B24_NUMEXP + ", " + P06BTablas.P06B_P06B24_IDENTIFICADOR;

	private static String SELECTALL_INCORPORACION_BY_EXP =
		" SELECT "
		+ "2 AS operacion, "
		+ "A." + P06BTablas.P06B_P06B24_IDENTIFICADOR + ", "
		+ "A." + P06BTablas.P06B_P06B24_NOMBRE + ", "
		+ "A." + P06BTablas.P06B_P06B24_APE1 + ", "
		+ "A." + P06BTablas.P06B_P06B24_APE2 + ", "
		+ "A." + P06BTablas.P06B_P06B24_DOMICI + ", "
		+ "A." + P06BTablas.P06B_P06B24_CODMUN + ", "
		+ "A." + P06BTablas.P06B_P06B24_LOCALI + ", "
		+ "A." + P06BTablas.P06B_P06B24_CODPRO + ", "
		+ "A." + P06BTablas.P06B_P06B24_CODPST + ", "
		+ "A." + P06BTablas.P06B_P06B24_PAIS + ", "
		+ "A." + P06BTablas.P06B_P06B24_PROFESI + ", "
		+ "A." + P06BTablas.P06B_P06B24_CURSO + ", "
		+ "A." + P06BTablas.P06B_P06B24_DENCURSO + ", "
		+ "A." + P06BTablas.P06B_P06B24_FECHNOM + ", "
		+ "A." + P06BTablas.P06B_P06B24_FECSUS + ", "
		+ "A." + P06BTablas.P06B_P06B24_FECLESUS + ", "
		+ "A." + P06BTablas.P06B_P06B24_FECREV + ", "
		+ "A." + P06BTablas.P06B_P06B24_FECINHA + ", "
		+ "A." + P06BTablas.P06B_P06B24_DURHAB + ", "
		+ "A." + P06BTablas.P06B_P06B24_FECCESE + ", "
		+ "A." + P06BTablas.P06B_P06B24_SANCIONES + ", "
		+ "A." + P06BTablas.P06B_P06B24_ACREDITA + ", "
		+ "A." + P06BTablas.P06B_P06B24_DACREDITA + ", "
		+ "A." + P06BTablas.P06B_P06B24_ACREDITAH + ", "
		+ "A." + P06BTablas.P06B_P06B24_DACREDITAH + ", "
		+ "A." + P06BTablas.P06B_P06B24_VINCULACIONES + ", "
		+ "A." + P06BTablas.P06B_P06B24_ENASEAUTORI + ", "
		+ "A." + P06BTablas.P06B_P06B24_IDCARGO + ", "
//		+ "A." + P06BTablas.P06B_P06B24_DENCARGO + ", "
		+ "S." + P06BTablas.P06B_P06B34_IDENTIFICADOR + ", "
		+ "S." + P06BTablas.P06B_P06B34_NOMBRE + ", "
		+ "S." + P06BTablas.P06B_P06B34_APE1 + ", "
		+ "S." + P06BTablas.P06B_P06B34_APE2 + ", "
		+ "S." + P06BTablas.P06B_P06B34_FECHNOM + ", "
		+ "S." + P06BTablas.P06B_P06B34_IDCARGO
		+ " FROM " + P06BTablas.P06B_P06B24T00_TABLA + " A,"
		+ P06BTablas.P06B_P06B34T00_TABLA + " S"
		+ " WHERE "
		+ "S." + P06BTablas.P06B_P06B34_NUMEXP + "=?"
		+ " AND S." + P06BTablas.P06B_P06B34_EJERCICIO + "=?"
		+ " AND S." + P06BTablas.P06B_P06B34_TIPO + "=?"
		+ " AND A." + P06BTablas.P06B_P06B24_NUMEXP + "=S." + P06BTablas.P06B_P06B34_NUMEXP
		+ " AND A." + P06BTablas.P06B_P06B24_TIPO + "=S." + P06BTablas.P06B_P06B34_TIPO
		+ " AND A." + P06BTablas.P06B_P06B24_IDENTIFICADOR + "=S." + P06BTablas.P06B_P06B34_IDENTIFICADOR
		+ " AND A." + P06BTablas.P06B_P06B24_IDCARGO + "=S." + P06BTablas.P06B_P06B34_IDCARGO
		+ " UNION"
		+ " SELECT 0, "
		+ "A." + P06BTablas.P06B_P06B24_IDENTIFICADOR + ", "
		+ "A." + P06BTablas.P06B_P06B24_NOMBRE + ", "
		+ "A." + P06BTablas.P06B_P06B24_APE1 + ", "
		+ "A." + P06BTablas.P06B_P06B24_APE2 + ", "
		+ "A." + P06BTablas.P06B_P06B24_DOMICI + ", "
		+ "A." + P06BTablas.P06B_P06B24_CODMUN + ", "
		+ "A." + P06BTablas.P06B_P06B24_LOCALI + ", "
		+ "A." + P06BTablas.P06B_P06B24_CODPRO + ", "
		+ "A." + P06BTablas.P06B_P06B24_CODPST + ", "
		+ "A." + P06BTablas.P06B_P06B24_PAIS + ", "
		+ "A." + P06BTablas.P06B_P06B24_PROFESI + ", "
		+ "A." + P06BTablas.P06B_P06B24_CURSO + ", "
		+ "A." + P06BTablas.P06B_P06B24_DENCURSO + ", "
		+ "A." + P06BTablas.P06B_P06B24_FECHNOM + ", "
		+ "A." + P06BTablas.P06B_P06B24_FECSUS + ", "
		+ "A." + P06BTablas.P06B_P06B24_FECLESUS + ", "
		+ "A." + P06BTablas.P06B_P06B24_FECREV + ", "
		+ "A." + P06BTablas.P06B_P06B24_FECINHA + ", "
		+ "A." + P06BTablas.P06B_P06B24_DURHAB + ", "
		+ "A." + P06BTablas.P06B_P06B24_FECCESE + ", "
		+ "A." + P06BTablas.P06B_P06B24_SANCIONES + ", "
		+ "A." + P06BTablas.P06B_P06B24_ACREDITA + ", "
		+ "A." + P06BTablas.P06B_P06B24_DACREDITA + ", "
		+ "A." + P06BTablas.P06B_P06B24_ACREDITAH + ", "
		+ "A." + P06BTablas.P06B_P06B24_DACREDITAH + ", "
		+ "A." + P06BTablas.P06B_P06B24_VINCULACIONES + ", "
		+ "A." + P06BTablas.P06B_P06B24_ENASEAUTORI + ", "
		+ "A." + P06BTablas.P06B_P06B24_IDCARGO + ", "
//		+ "A." + P06BTablas.P06B_P06B24_DENCARGO + ", "
		+ "NULL, NULL, NULL, NULL, NULL, NULL"
		+ " FROM " + P06BTablas.P06B_P06B24T00_TABLA + " A,("
		+ "SELECT "
		+ P06BTablas.P06B_P06B24_IDENTIFICADOR + ", " + P06BTablas.P06B_P06B24_IDCARGO + " FROM " + P06BTablas.P06B_P06B24T00_TABLA + " T1"
		+ " WHERE "
		+ "T1." + P06BTablas.P06B_P06B24_NUMEXP + "=?"
		+ " AND T1." + P06BTablas.P06B_P06B24_TIPO + "=?"
		+ " MINUS "
		+ "SELECT "
		+ "S." + P06BTablas.P06B_P06B34_IDENTIFICADOR + ", " + P06BTablas.P06B_P06B34_IDCARGO + " FROM " + P06BTablas.P06B_P06B34T00_TABLA + " S"
		+ " WHERE "
		+ "S." + P06BTablas.P06B_P06B34_NUMEXP + "=?"
		+ " AND S." + P06BTablas.P06B_P06B34_EJERCICIO + "=?"
		+ " AND S." + P06BTablas.P06B_P06B34_TIPO + "=?"
		+ " ) C"
		+ " WHERE "
		+ "A." + P06BTablas.P06B_P06B24_TIPO + "=?"
		+ " AND A." + P06BTablas.P06B_P06B24_NUMEXP + "=?"
		+ " AND C." + P06BTablas.P06B_P06B24_IDENTIFICADOR + "=A." + P06BTablas.P06B_P06B24_IDENTIFICADOR
		+ " AND C." + P06BTablas.P06B_P06B24_IDCARGO + "=A." + P06BTablas.P06B_P06B24_IDCARGO
		+ " UNION"
		+ " SELECT "
		+ "1, "
		+ "NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "
		+ "NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "
		+ "NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "
		+ "NULL, NULL, NULL, NULL, "
		+ "A." + P06BTablas.P06B_P06B34_IDENTIFICADOR + ", "
		+ "A." + P06BTablas.P06B_P06B34_NOMBRE + ", "
		+ "A." + P06BTablas.P06B_P06B34_APE1 + ", "
		+ "A." + P06BTablas.P06B_P06B34_APE2 + ", "
		+ "A." + P06BTablas.P06B_P06B34_FECHNOM + ", "
		+ "A." + P06BTablas.P06B_P06B34_IDCARGO
		+ " FROM " + P06BTablas.P06B_P06B34T00_TABLA + " A,("
		+ "SELECT "
		+ "S." + P06BTablas.P06B_P06B34_IDENTIFICADOR + ", " + P06BTablas.P06B_P06B34_IDCARGO + " FROM " + P06BTablas.P06B_P06B34T00_TABLA + " S"
		+ " WHERE "
		+ "S." + P06BTablas.P06B_P06B34_NUMEXP + "=?"
		+ " AND S." + P06BTablas.P06B_P06B34_EJERCICIO + "=?"
		+ " AND S." + P06BTablas.P06B_P06B34_TIPO + "=?"
		+ " MINUS "
		+ "SELECT "
		+ P06BTablas.P06B_P06B24_IDENTIFICADOR + ", " + P06BTablas.P06B_P06B24_IDCARGO + " FROM " + P06BTablas.P06B_P06B24T00_TABLA + " T1"
		+ " WHERE "
		+ "T1." + P06BTablas.P06B_P06B24_NUMEXP + "=?"
		+ " AND T1." + P06BTablas.P06B_P06B24_TIPO + "=?) C"
		+ " WHERE "
		+ "A." + P06BTablas.P06B_P06B34_TIPO + "=?"
		+ " AND A." + P06BTablas.P06B_P06B34_NUMEXP + "=?"
		+ " AND C." + P06BTablas.P06B_P06B34_IDENTIFICADOR + "=A." + P06BTablas.P06B_P06B34_IDENTIFICADOR
		+ " AND C." + P06BTablas.P06B_P06B34_IDCARGO + "=A." + P06BTablas.P06B_P06B34_IDCARGO
		+ " ORDER BY 1 DESC,2";

	private static String SELECTALL_INCORPORACIONMODTRAMITAGUNE_BY_EXP =
		" SELECT "
		+ "2 AS operacion, "
		+ "A." + P06BTablas.P06B_P06B24_IDENTIFICADOR + ", "
		+ "A." + P06BTablas.P06B_P06B24_NOMBRE + ", "
		+ "A." + P06BTablas.P06B_P06B24_APE1 + ", "
		+ "A." + P06BTablas.P06B_P06B24_APE2 + ", "
		+ "A." + P06BTablas.P06B_P06B24_DOMICI + ", "
		+ "A." + P06BTablas.P06B_P06B24_CODMUN + ", "
		+ "A." + P06BTablas.P06B_P06B24_LOCALI + ", "
		+ "A." + P06BTablas.P06B_P06B24_CODPRO + ", "
		+ "A." + P06BTablas.P06B_P06B24_CODPST + ", "
		+ "A." + P06BTablas.P06B_P06B24_PAIS + ", "
		+ "A." + P06BTablas.P06B_P06B24_PROFESI + ", "
		+ "A." + P06BTablas.P06B_P06B24_CURSO + ", "
		+ "A." + P06BTablas.P06B_P06B24_DENCURSO + ", "
		+ "A." + P06BTablas.P06B_P06B24_FECHNOM + ", "
		+ "A." + P06BTablas.P06B_P06B24_FECSUS + ", "
		+ "A." + P06BTablas.P06B_P06B24_FECLESUS + ", "
		+ "A." + P06BTablas.P06B_P06B24_FECREV + ", "
		+ "A." + P06BTablas.P06B_P06B24_FECINHA + ", "
		+ "A." + P06BTablas.P06B_P06B24_DURHAB + ", "
		+ "A." + P06BTablas.P06B_P06B24_FECCESE + ", "
		+ "A." + P06BTablas.P06B_P06B24_SANCIONES + ", "
		+ "A." + P06BTablas.P06B_P06B24_ACREDITA + ", "
		+ "A." + P06BTablas.P06B_P06B24_DACREDITA + ", "
		+ "A." + P06BTablas.P06B_P06B24_ACREDITAH + ", "
		+ "A." + P06BTablas.P06B_P06B24_DACREDITAH + ", "
		+ "A." + P06BTablas.P06B_P06B24_VINCULACIONES + ", "
		+ "A." + P06BTablas.P06B_P06B24_ENASEAUTORI + ", "
		+ "A." + P06BTablas.P06B_P06B24_IDCARGO + ", "
		+ "S." + P06BTablas.P06B_P06B74_OD_IDENTIFICADOR + ", "
		+ "S." + P06BTablas.P06B_P06B74_OD_NOMBRE + ", "
		+ "S." + P06BTablas.P06B_P06B74_OD_FECHNOM + ", "
		+ "TO_CHAR(S." + P06BTablas.P06B_P06B74_OD_IDCARGO + ",'FM00') AS " + P06BTablas.P06B_P06B74_OD_IDCARGO + ", "
		+ "S." + P06BTablas.P06B_P06B74_OD_IDCURSO + ", "
		+ "S." + P06BTablas.P06B_P06B74_OD_DENCURSO
		+ " FROM " + P06BTablas.P06B_P06B24T00_TABLA + " A,"
		+ P06BTablas.P06B_P06B74T00_TABLA + " S"
		+ " WHERE "
		+ "S." + P06BTablas.P06B_P06B74_OD_NUMEXP + "=?"
		+ " AND S." + P06BTablas.P06B_P06B74_OD_CORRELATENCPETIC + "=?"
		+ " AND S." + P06BTablas.P06B_P06B74_OD_TIPO + "=?"
		+ " AND A." + P06BTablas.P06B_P06B24_NUMEXP + "=S." + P06BTablas.P06B_P06B74_OD_NUMEXP
		+ " AND A." + P06BTablas.P06B_P06B24_TIPO + "=S." + P06BTablas.P06B_P06B74_OD_TIPO
		+ " AND A." + P06BTablas.P06B_P06B24_IDENTIFICADOR + "=S." + P06BTablas.P06B_P06B74_OD_IDENTIFICADOR
		+ " AND A." + P06BTablas.P06B_P06B24_IDCARGO + "=TO_CHAR(S." + P06BTablas.P06B_P06B74_OD_IDCARGO + ",'FM00')"
		+ " UNION"
		+ " SELECT "
		+ "1, "
		+ "NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "
		+ "NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "
		+ "NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "
		+ "NULL, NULL, NULL, NULL, "
		+ "A." + P06BTablas.P06B_P06B74_OD_IDENTIFICADOR + ", "
		+ "A." + P06BTablas.P06B_P06B74_OD_NOMBRE + ", "
		+ "A." + P06BTablas.P06B_P06B74_OD_FECHNOM + ", "
		+ "TO_CHAR(A." + P06BTablas.P06B_P06B74_OD_IDCARGO + ",'FM00'), "
		+ "A." + P06BTablas.P06B_P06B74_OD_IDCURSO + ", "
		+ "A." + P06BTablas.P06B_P06B74_OD_DENCURSO
		+ " FROM " + P06BTablas.P06B_P06B74T00_TABLA + " A,("
		+ "SELECT "
		+ "S." + P06BTablas.P06B_P06B74_OD_IDENTIFICADOR + ", TO_CHAR(" + P06BTablas.P06B_P06B74_OD_IDCARGO + ",'FM00') AS " + P06BTablas.P06B_P06B74_OD_IDCARGO + " FROM " + P06BTablas.P06B_P06B74T00_TABLA + " S"
		+ " WHERE "
		+ "S." + P06BTablas.P06B_P06B74_OD_NUMEXP + "=?"
		+ " AND S." + P06BTablas.P06B_P06B74_OD_CORRELATENCPETIC + "=?"
		+ " AND S." + P06BTablas.P06B_P06B74_OD_TIPO + "=?"
		+ " MINUS "
		+ "SELECT "
		+ P06BTablas.P06B_P06B24_IDENTIFICADOR + ", " + P06BTablas.P06B_P06B24_IDCARGO + " FROM " + P06BTablas.P06B_P06B24T00_TABLA + " T1"
		+ " WHERE "
		+ "T1." + P06BTablas.P06B_P06B24_NUMEXP + "=?"
		+ " AND T1." + P06BTablas.P06B_P06B24_TIPO + "=?) C"
		+ " WHERE "
		+ "A." + P06BTablas.P06B_P06B74_OD_CORRELATENCPETIC + "=?"
		+ " AND A." + P06BTablas.P06B_P06B74_OD_TIPO + "=?"
		+ " AND A." + P06BTablas.P06B_P06B74_OD_NUMEXP + "=?"
		+ " AND C." + P06BTablas.P06B_P06B74_OD_IDENTIFICADOR + "=A." + P06BTablas.P06B_P06B74_OD_IDENTIFICADOR
		+ " AND C." + P06BTablas.P06B_P06B74_OD_IDCARGO + "=A." + P06BTablas.P06B_P06B74_OD_IDCARGO
		+ " ORDER BY 1 DESC,2";

	private static String SELECTALL_INCORPORACIONMODTRAMITAGUNE_BY_EXPOLD =
		" SELECT "
		+ "2 AS operacion, "
		+ "A." + P06BTablas.P06B_P06B24_IDENTIFICADOR + ", "
		+ "A." + P06BTablas.P06B_P06B24_NOMBRE + ", "
		+ "A." + P06BTablas.P06B_P06B24_APE1 + ", "
		+ "A." + P06BTablas.P06B_P06B24_APE2 + ", "
		+ "A." + P06BTablas.P06B_P06B24_DOMICI + ", "
		+ "A." + P06BTablas.P06B_P06B24_CODMUN + ", "
		+ "A." + P06BTablas.P06B_P06B24_LOCALI + ", "
		+ "A." + P06BTablas.P06B_P06B24_CODPRO + ", "
		+ "A." + P06BTablas.P06B_P06B24_CODPST + ", "
		+ "A." + P06BTablas.P06B_P06B24_PAIS + ", "
		+ "A." + P06BTablas.P06B_P06B24_PROFESI + ", "
		+ "A." + P06BTablas.P06B_P06B24_CURSO + ", "
		+ "A." + P06BTablas.P06B_P06B24_DENCURSO + ", "
		+ "A." + P06BTablas.P06B_P06B24_FECHNOM + ", "
		+ "A." + P06BTablas.P06B_P06B24_FECSUS + ", "
		+ "A." + P06BTablas.P06B_P06B24_FECLESUS + ", "
		+ "A." + P06BTablas.P06B_P06B24_FECREV + ", "
		+ "A." + P06BTablas.P06B_P06B24_FECINHA + ", "
		+ "A." + P06BTablas.P06B_P06B24_DURHAB + ", "
		+ "A." + P06BTablas.P06B_P06B24_FECCESE + ", "
		+ "A." + P06BTablas.P06B_P06B24_SANCIONES + ", "
		+ "A." + P06BTablas.P06B_P06B24_ACREDITA + ", "
		+ "A." + P06BTablas.P06B_P06B24_DACREDITA + ", "
		+ "A." + P06BTablas.P06B_P06B24_ACREDITAH + ", "
		+ "A." + P06BTablas.P06B_P06B24_DACREDITAH + ", "
		+ "A." + P06BTablas.P06B_P06B24_VINCULACIONES + ", "
		+ "A." + P06BTablas.P06B_P06B24_ENASEAUTORI + ", "
		+ "A." + P06BTablas.P06B_P06B24_IDCARGO + ", "
//		+ "A." + P06BTablas.P06B_P06B24_DENCARGO + ", "
		+ "S." + P06BTablas.P06B_P06B74_OD_IDENTIFICADOR + ", "
//		+ "S." + P06BTablas.P06B_P06B74_OD_TIPO1 + ", "
		+ "S." + P06BTablas.P06B_P06B74_OD_NOMBRE + ", "
		+ "S." + P06BTablas.P06B_P06B74_OD_FECHNOM + ", "
		+ "TO_CHAR(S." + P06BTablas.P06B_P06B74_OD_IDCARGO + ",'FM00') AS " + P06BTablas.P06B_P06B74_OD_IDCARGO + ", "
//		+ "S." + P06BTablas.P06B_P06B74_OD_IDREP + ", "
//		+ "S." + P06BTablas.P06B_P06B74_OD_NOMREP + ", "
		+ "S." + P06BTablas.P06B_P06B74_OD_IDCURSO + ", "
		+ "S." + P06BTablas.P06B_P06B74_OD_DENCURSO
		+ " FROM " + P06BTablas.P06B_P06B24T00_TABLA + " A,"
		+ P06BTablas.P06B_P06B74T00_TABLA + " S"
		+ " WHERE "
		+ "S." + P06BTablas.P06B_P06B74_OD_NUMEXP + "=?"
		+ " AND S." + P06BTablas.P06B_P06B74_OD_CORRELATENCPETIC + "=?"
		+ " AND S." + P06BTablas.P06B_P06B74_OD_TIPO + "=?"
		+ " AND A." + P06BTablas.P06B_P06B24_NUMEXP + "=S." + P06BTablas.P06B_P06B74_OD_NUMEXP
		+ " AND A." + P06BTablas.P06B_P06B24_TIPO + "=S." + P06BTablas.P06B_P06B74_OD_TIPO
		+ " AND A." + P06BTablas.P06B_P06B24_IDENTIFICADOR + "=S." + P06BTablas.P06B_P06B74_OD_IDENTIFICADOR
		+ " AND A." + P06BTablas.P06B_P06B24_IDCARGO + "=TO_CHAR(S." + P06BTablas.P06B_P06B74_OD_IDCARGO + ",'FM00')"
		+ " UNION"
		+ " SELECT 0, "
		+ "A." + P06BTablas.P06B_P06B24_IDENTIFICADOR + ", "
		+ "A." + P06BTablas.P06B_P06B24_NOMBRE + ", "
		+ "A." + P06BTablas.P06B_P06B24_APE1 + ", "
		+ "A." + P06BTablas.P06B_P06B24_APE2 + ", "
		+ "A." + P06BTablas.P06B_P06B24_DOMICI + ", "
		+ "A." + P06BTablas.P06B_P06B24_CODMUN + ", "
		+ "A." + P06BTablas.P06B_P06B24_LOCALI + ", "
		+ "A." + P06BTablas.P06B_P06B24_CODPRO + ", "
		+ "A." + P06BTablas.P06B_P06B24_CODPST + ", "
		+ "A." + P06BTablas.P06B_P06B24_PAIS + ", "
		+ "A." + P06BTablas.P06B_P06B24_PROFESI + ", "
		+ "A." + P06BTablas.P06B_P06B24_CURSO + ", "
		+ "A." + P06BTablas.P06B_P06B24_DENCURSO + ", "
		+ "A." + P06BTablas.P06B_P06B24_FECHNOM + ", "
		+ "A." + P06BTablas.P06B_P06B24_FECSUS + ", "
		+ "A." + P06BTablas.P06B_P06B24_FECLESUS + ", "
		+ "A." + P06BTablas.P06B_P06B24_FECREV + ", "
		+ "A." + P06BTablas.P06B_P06B24_FECINHA + ", "
		+ "A." + P06BTablas.P06B_P06B24_DURHAB + ", "
		+ "A." + P06BTablas.P06B_P06B24_FECCESE + ", "
		+ "A." + P06BTablas.P06B_P06B24_SANCIONES + ", "
		+ "A." + P06BTablas.P06B_P06B24_ACREDITA + ", "
		+ "A." + P06BTablas.P06B_P06B24_DACREDITA + ", "
		+ "A." + P06BTablas.P06B_P06B24_ACREDITAH + ", "
		+ "A." + P06BTablas.P06B_P06B24_DACREDITAH + ", "
		+ "A." + P06BTablas.P06B_P06B24_VINCULACIONES + ", "
		+ "A." + P06BTablas.P06B_P06B24_ENASEAUTORI + ", "
		+ "A." + P06BTablas.P06B_P06B24_IDCARGO + ", "
//		+ "A." + P06BTablas.P06B_P06B24_DENCARGO + ", "
//		+ "NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL"
//		+ "NULL, NULL, NULL, NULL, NULL,             NULL, NULL"
		+ "NULL,       NULL, NULL, NULL,             NULL, NULL"
		+ " FROM " + P06BTablas.P06B_P06B24T00_TABLA + " A,("
		+ "SELECT "
		+ P06BTablas.P06B_P06B24_IDENTIFICADOR + ", " + P06BTablas.P06B_P06B24_IDCARGO + " FROM " + P06BTablas.P06B_P06B24T00_TABLA + " T1"
		+ " WHERE "
		+ "T1." + P06BTablas.P06B_P06B24_NUMEXP + "=?"
		+ " AND T1." + P06BTablas.P06B_P06B24_TIPO + "=?"
		+ " MINUS "
		+ "SELECT "
		+ "S." + P06BTablas.P06B_P06B74_OD_IDENTIFICADOR + ", TO_CHAR(" + P06BTablas.P06B_P06B74_OD_IDCARGO + ",'FM00') AS " + P06BTablas.P06B_P06B74_OD_IDCARGO + " FROM " + P06BTablas.P06B_P06B74T00_TABLA + " S"
		+ " WHERE "
		+ "S." + P06BTablas.P06B_P06B74_OD_NUMEXP + "=?"
		+ " AND S." + P06BTablas.P06B_P06B74_OD_CORRELATENCPETIC + "=?"
		+ " AND S." + P06BTablas.P06B_P06B74_OD_TIPO + "=?"
		+ " ) C"
		+ " WHERE "
		+ "A." + P06BTablas.P06B_P06B24_TIPO + "=?"
		+ " AND A." + P06BTablas.P06B_P06B24_NUMEXP + "=?"
		+ " AND C." + P06BTablas.P06B_P06B24_IDENTIFICADOR + "=A." + P06BTablas.P06B_P06B24_IDENTIFICADOR
		+ " AND C." + P06BTablas.P06B_P06B24_IDCARGO + "=A." + P06BTablas.P06B_P06B24_IDCARGO
		+ " UNION"
		+ " SELECT "
		+ "1, "
		+ "NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "
		+ "NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "
		+ "NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "
		+ "NULL, NULL, NULL, NULL, "
		+ "A." + P06BTablas.P06B_P06B74_OD_IDENTIFICADOR + ", "
//		+ "A." + P06BTablas.P06B_P06B74_OD_TIPO1 + ", "
		+ "A." + P06BTablas.P06B_P06B74_OD_NOMBRE + ", "
		+ "A." + P06BTablas.P06B_P06B74_OD_FECHNOM + ", "
		+ "TO_CHAR(A." + P06BTablas.P06B_P06B74_OD_IDCARGO + ",'FM00'), "
//		+ "A." + P06BTablas.P06B_P06B74_OD_IDREP + ", "
//		+ "A." + P06BTablas.P06B_P06B74_OD_NOMREP + ", "
		+ "A." + P06BTablas.P06B_P06B74_OD_IDCURSO + ", "
		+ "A." + P06BTablas.P06B_P06B74_OD_DENCURSO
		+ " FROM " + P06BTablas.P06B_P06B74T00_TABLA + " A,("
		+ "SELECT "
		+ "S." + P06BTablas.P06B_P06B74_OD_IDENTIFICADOR + ", TO_CHAR(" + P06BTablas.P06B_P06B74_OD_IDCARGO + ",'FM00') AS " + P06BTablas.P06B_P06B74_OD_IDCARGO + " FROM " + P06BTablas.P06B_P06B74T00_TABLA + " S"
		+ " WHERE "
		+ "S." + P06BTablas.P06B_P06B74_OD_NUMEXP + "=?"
		+ " AND S." + P06BTablas.P06B_P06B74_OD_CORRELATENCPETIC + "=?"
		+ " AND S." + P06BTablas.P06B_P06B74_OD_TIPO + "=?"
		+ " MINUS "
		+ "SELECT "
		+ P06BTablas.P06B_P06B24_IDENTIFICADOR + ", " + P06BTablas.P06B_P06B24_IDCARGO + " FROM " + P06BTablas.P06B_P06B24T00_TABLA + " T1"
		+ " WHERE "
		+ "T1." + P06BTablas.P06B_P06B24_NUMEXP + "=?"
		+ " AND T1." + P06BTablas.P06B_P06B24_TIPO + "=?) C"
		+ " WHERE "
		+ "A." + P06BTablas.P06B_P06B74_OD_TIPO + "=?"
		+ " AND A." + P06BTablas.P06B_P06B74_OD_NUMEXP + "=?"
		+ " AND C." + P06BTablas.P06B_P06B74_OD_IDENTIFICADOR + "=A." + P06BTablas.P06B_P06B74_OD_IDENTIFICADOR
		+ " AND C." + P06BTablas.P06B_P06B74_OD_IDCARGO + "=A." + P06BTablas.P06B_P06B74_OD_IDCARGO
		+ " ORDER BY 1 DESC,2";

	private static String SELECT_NUMREGS =
		"SELECT COUNT(*) "
		+" FROM " + P06BTablas.P06B_P06B24T00_TABLA
		+" WHERE " + P06BTablas.P06B_P06B24_NUMEXP + "= ? "
			+ " AND " + P06BTablas.P06B_P06B24_TIPO + "= TO_NUMBER(?)";
}